﻿var simulations = {
    context: $(".v-simulations"),
    datatable: null,
    treeview: null,
    autoUpdateTimerId: null,    
    selectedQuestionName: "",
    initializeDataTable: function (questionName) {
        this.datatable = $(".h-answersTable", simulations.context).a4datatable({
            height: "full",
            lengthMenu: [
                [10, 20, 50, 100, 500, 1000],
                ['10', '20', '50', '100', '500', '1000']
            ],
            displayLength: 1000,
            ajaxAction: a4.getProjectAction("GetQuestionCodes", "Simulation"),
            ajaxParams: { "questionName": questionName },
            columns: [
                { "Title": resources.Code, "Data": "Code", "Type": "string", "Editable": false },
                { "Title": resources.Label, "Data": "Label", "Type": "string", "Editable": false },
                { "Title": resources.Distribution, "Data": "Distribution", "HideInSelector": true, "Type": "numeric", "Editable": true }
            ],
            allowRowSelection: false,
            multiEdit: true,
            rowsUpdated: function (event, data) {
                var codes = _.map(data.rows, function (obj) { return _.omit(obj, "Label"); });
                a4.callServerMethod(a4.getProjectAction("EditQuestionCodes", "Simulation"), { questionName: simulations.selectedQuestionName, questionCodes: codes },
                    function (result) {
                        if (result.success) {
                            data.multiEditSaveCallback();
                        }
                        else {
                            a4.showErrorMessage(result.errorMessage);
                        }
                    });
            },
            rowUpdated: function (event, data) {
                if (data.value < 0 || data.value > 100)
                    data.flagError(true);
            },
            localizableTexts: { "Search": resources.SearchCodes }
        });
    },
    initializeTreeView: function () {
        this.treeview = $(".h-questionsList", simulations.context).a4listview({
            ajaxAction: a4.getProjectAction("GetQuestionnaireQuestions", "Simulation"),
            icons: { Custom: [{}] },
            draw: function (event, data) {
                var question = data.selectedNode;
                var questionName = question ? (question.Name || "") : "";

                if (simulations.datatable) {
                    simulations.datatable.a4datatable("option", "ajaxParams", { "questionName": questionName });
                    simulations.datatable.a4datatable("refresh");
                }
                else {
                    simulations.initializeDataTable(questionName);
                }

                $(".v-tableContainer", simulations.context).toggleClass("right-panel", data.count > 1);
                $(this).toggle(data.count > 1);
            },
            selectNode: function (event, data) {
                simulations.selectedQuestionName = data.node.Name;
                simulations.datatable.a4datatable("option", "ajaxParams", { "questionName": data.node.Name });
                simulations.datatable.a4datatable("refresh", true);
            },
            actionButtons: [
                { Action: "reset", Label: resources.Reset, Icon: "refresh", "DisplayCondition": function (data) { return data.ParentId > 0; } },
                { Action: "adjust", Label: resources.Adjust, Icon: "calculator", "DisplayCondition": function (data) { return data.ParentId > 0; } },
                { Action: "clear", Label: resources.Clear, Icon: "remove", "DisplayCondition": function (data) { return data.ParentId > 0; } }
            ],
            actionButtonClick: function (event, data) {
                var action = data.action;
                var node = data.node;

                switch (action) {
                    case "reset":
                        simulations.resetQuestionDistribution(node.Name);
                        break;
                    case "adjust":
                        simulations.adjustQuestionDistribution(node.Name);
                        break;
                    case "clear":
                        simulations.clearQuestionDistribution(node.Name);
                        break;
                }
            },
            localizableTexts: { "Search": resources.SearchQuestions }
        });
    },
    bindEvents: function () {
        $(".h-simulationmenu").on("click", "li.h-resetalldistribution", function () {
            modalDialog.showConfirmDialog(confirmResetAllDistributionResources, function () {
                a4.callServerMethod(a4.getProjectAction("ResetAllDistribution", "Simulation"), {}, function (result) {
                    simulations.startAutoUpdate();
                    simulations.refreshContent();
                });
            }, 180, 400, false);
        });


        $(".h-simulationmenu").on("click", "li.h-startsimulation", function () {
            modalDialog.showWindow(a4.getProjectAction("EditSimulation", "Simulation", {}), 500, 700, {
                afterClose: function () {
                    simulations.startAutoUpdate();
                }
            });
        });

        $(".h-simulationmenu").on("click", "li.h-abortsimulation", function () {
            modalDialog.showConfirmDialog(confirmAbortSimulationResources, function () {
                a4.callServerMethod(a4.getProjectAction("AbortSimulation", "Simulation"), {}, function (result) {
                    simulations.stopAutoUpdate();
                    simulations.updateSimulationStatus();
                });
            }, 180, 400, false);
        });
        
        $(".h-simulationmenu").on("click", "li.h-export", function () {
            a4.showBusyBox();

            a4.callServerMethod(a4.getProjectAction("SaveSimulationAs", "Simulation"), {},
                function (result) {
                    a4.hideBusyBox();
                    window.location = a4.getProjectAction("GetSimulationFile", "Simulation", { fileName: result });
                });
        });

        $(".h-simulationmenu").on("click", "li.h-import", function () {
            modalDialog.showWindow(a4.getProjectAction("ImportSimulation", "Simulation"), 300, 600, { afterClose: function () { simulations.refreshContent(); } });
        });
    },
    refreshContent: function () {
        simulations.treeview.a4listview("refresh");
    },
    resetQuestionDistribution: function (questionName) {
        modalDialog.showConfirmDialog(confirmResetQuestionDistributionResources, function () {
            a4.callServerMethod(a4.getProjectAction("ResetQuestionCodesDistribution", "Simulation"), { questionName: questionName }, function (result) {
                simulations.refreshContent();
            });
        }, 180, 450, false, { "questionName": questionName });
    },
    adjustQuestionDistribution: function (questionName) {
        a4.callServerMethod(a4.getProjectAction("AdjustQuestionCodesDistribution", "Simulation"), { questionName: questionName }, function (result) {
            simulations.refreshContent();
        });
    },
    clearQuestionDistribution: function (questionName) {
        a4.callServerMethod(a4.getProjectAction("ClearQuestionCodesDistribution", "Simulation"), { questionName: questionName }, function (result) {
            simulations.refreshContent();
        });
    },
    showBusyBox: function () {
        a4.showBusyBox();
    },
    hideBusyBox: function () {
        a4.hideBusyBox();
    },
    updateSimulationStatus: function ()
    {
        a4.callServerMethod(a4.getProjectAction("GetSimulationStatus", "Simulation"), {}, function (result) {
            simulations.setSimulationStatus(result);
        });
    },
    setSimulationStatus: function(status)
    {
        $(".v-surveyCount", this.context).html(status.Message);                         

        $(".h-abortsimulation", this.context).toggle(status.Status == 3);
        $(".h-startsimulation", this.context).toggle(status.Status != 3);
                
        if (status.Status != 3) {
            this.stopAutoUpdate();
        }
    },
    stopAutoUpdate: function()
    {
        if (this.autoUpdateTimerId) {
            clearInterval(this.autoUpdateTimerId);

            this.autoUpdateTimerId = null;            
        }           
    
    },
    startAutoUpdate: function()
    {
        if (!this.autoUpdateTimerId) {
            this.autoUpdateTimerId = setInterval(function () {

                simulations.updateSimulationStatus();

            }, 5000);
        }
    }
}



$(document).ready(function () {
    if (simulations.context.length > 0) {
        simulations.initializeTreeView();
        simulations.bindEvents();
        simulations.updateSimulationStatus();
        simulations.startAutoUpdate();       
    }
});